/*
 * Decompiled with CFR 0.152.
 */
package com.sinovatech.mobile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class URLEncoder {
    private static boolean[] dontNeedEncoding;
    private static String defaultEncName;
    static final int caseDiff = 32;
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;

    private URLEncoder() {
    }

    public static String encode(String s) {
        String str = null;
        str = URLEncoder.encode(s, defaultEncName);
        return str;
    }

    public static String encode(String s, String enc) {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, enc);
        }
        catch (UnsupportedEncodingException ex) {
            try {
                writer = new OutputStreamWriter((OutputStream)buf, defaultEncName);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (c < 256 && dontNeedEncoding[c]) {
                if (c == 32) {
                    c = 43;
                    needToChange = true;
                }
                out.append((char)c);
                wroteUnencodedChar = true;
                continue;
            }
            try {
                char d;
                if (wroteUnencodedChar) {
                    writer = new OutputStreamWriter((OutputStream)buf, enc);
                    wroteUnencodedChar = false;
                }
                if (writer != null) {
                    writer.write(c);
                }
                if (c >= 55296 && c <= 56319 && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    writer.write(d);
                    ++i;
                }
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = URLEncoder.forDigit(ba[j] >> 4 & 0xF, 16);
                if (URLEncoder.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = URLEncoder.forDigit(ba[j] & 0xF, 16);
                if (URLEncoder.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static char forDigit(int digit, int radix) {
        if (digit >= radix || digit < 0) {
            return '\u0000';
        }
        if (radix < 2 || radix > 36) {
            return '\u0000';
        }
        if (digit < 10) {
            return (char)(48 + digit);
        }
        return (char)(87 + digit);
    }

    static {
        int i;
        defaultEncName = "";
        dontNeedEncoding = new boolean[256];
        for (i = 97; i <= 122; ++i) {
            URLEncoder.dontNeedEncoding[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            URLEncoder.dontNeedEncoding[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            URLEncoder.dontNeedEncoding[i] = true;
        }
        URLEncoder.dontNeedEncoding[32] = true;
        URLEncoder.dontNeedEncoding[45] = true;
        URLEncoder.dontNeedEncoding[95] = true;
        URLEncoder.dontNeedEncoding[46] = true;
        URLEncoder.dontNeedEncoding[42] = true;
        defaultEncName = System.getProperty("microedition.encoding");
        if (defaultEncName == null || defaultEncName.trim().length() == 0) {
            defaultEncName = "UTF-8";
        }
    }
}

