;define
!define AppName "yong"
!define PRODUCT_NAME "СС뷨"
!define PRODUCT_VERSION "2.0.0"
!define PRODUCT_VERSION_MINOR "2"
!define PRODUCT_PUBLISHER "dgod"
!define PRODUCT_WEB_SITE "http://yong.dgod.net"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

RequestExecutionLevel admin

; zip
SetCompressor /FINAL /SOLID lzma

; include
!include MUI2.nsh
!include "TextFunc.nsh"

; info
Name ${PRODUCT_NAME}
OutFile ${AppName}-${PRODUCT_VERSION}-${PRODUCT_VERSION_MINOR}.exe
InstallDir $PROGRAMFILES\${AppName}
InstallDirRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstallLocation"
DirText ѡ${PRODUCT_NAME}İװ·
BrandingText ${PRODUCT_NAME}-${PRODUCT_WEB_SITE}

LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
;--------------------------------
;Version Information

  VIProductVersion "${PRODUCT_VERSION}.0"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "ProductName" "${PRODUCT_NAME}"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "Comments" "${PRODUCT_NAME}"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "CompanyName" "dgod"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalTrademarks" ""
  VIAddVersionKey /LANG=${LANG_ENGLISH} "LegalCopyright" ""
  VIAddVersionKey /LANG=${LANG_ENGLISH} "FileDescription" "${PRODUCT_NAME}"
  VIAddVersionKey /LANG=${LANG_ENGLISH} "FileVersion" "${PRODUCT_VERSION}"

;--------------------------------

; MUI config
!define MUI_ABORTWARNING
!define MUI_ICON "skin\tray1.ico"

;Select Lang
Function .onInit
  ;!insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Icon skin\tray1.ico
LicenseData README.txt
XPStyle on

CompletedText "װ"
ShowInstDetails nevershow
DetailsButtonText "ʾϸ"

;Pages
!define MUI_WELCOMEPAGE_TITLE "ӭʹ"
!define MUI_WELCOMEPAGE_TEXT  "뷨һ$\r$\nʹöʽ$\r$\nϵͳƽ̨$\r$\n֧androidֻ$\r$\nǿĿɶ$\r$\n"
!insertmacro MUI_PAGE_WELCOME
!define MUI_LICENSEPAGE_CHECKBOX
!define MUI_PAGE_HEADER_TEXT "ȨЭ"
!define MUI_PAGE_HEADER_SUBTEXT "ϸĶ"
!define MUI_INNERTEXT_LICENSE_TOP "СС뷨ȨЭ"
!insertmacro MUI_PAGE_LICENSE "README.txt"
!define MUI_PAGE_HEADER_TEXT "ѡ"
!define MUI_PAGE_HEADER_SUBTEXT "ԼҪѡ"
!insertmacro MUI_PAGE_COMPONENTS
!define MUI_PAGE_HEADER_TEXT "װ·"
!insertmacro MUI_PAGE_DIRECTORY
!define MUI_PAGE_HEADER_TEXT "ڰװ"
!insertmacro MUI_PAGE_INSTFILES
!define MUI_FINISHPAGE_TITLE "װ"
!define MUI_FINISHPAGE_RUN "$INSTDIR\yong.exe"
!insertmacro MUI_PAGE_FINISH
;!insertmacro MUI_UNPAGE_CONFIRM

; language
!insertmacro MUI_LANGUAGE "SimpChinese"

Section "-hidden section" SecMain

loop:
FindWindow $R0 "yong_main"
IntCmp $R0 0 done
MessageBox MB_OKCANCEL "С$\nȷťرճȻװȡť˳װ" IDOK NoAbort
Abort
NoAbort:
SendMessage $R0 2 0 0
; ԵȺֱⲻûѡȡ
Sleep 444
Goto loop
done:

SetOutPath $INSTDIR

File yong.exe
File yong-config.exe
File libmb.so
File libgbk.so
File libcloud.so
File libl.dll

File yong.ini
File bihua.bin
File class.txt
File README.txt
File yong.chm
File keyboard.ini
File normal.txt

SetOutPath $INSTDIR\mb

File mb\*

SetOutPath $INSTDIR\skin

File skin\*

SetOutPath $INSTDIR
  CreateShortCut "$SMSTARTUP\${PRODUCT_NAME}.lnk" "$INSTDIR\yong.exe" "" "$INSTDIR\yong.exe" 0
WriteUninstaller $INSTDIR\uninstall.exe

WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninstall.exe"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstallLocation" "$INSTDIR"
WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstallProgram" "$INSTDIR\${AppName}.exe"

SectionEnd

Section "ʼ˵" SecMenu
  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\README.lnk" "$INSTDIR\README.txt" "" "$WINDIR\notepad.exe" 0
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\ж.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
SectionEnd

Section /o "IME뷨" SecIME

SetOutPath $INSTDIR\imm

File imm\yong.dll
File imm\yong64.dll
File imm\install.bat
File imm\uninstall.bat

ExecWait '"rundll32.exe" "$INSTDIR\imm\yong.dll" Reg'

${ConfigWrite} "$INSTDIR\yong.ini" "switch=" "NONE" $R0
${ConfigWrite} "$INSTDIR\yong.ini" "trigger=" "CTRL_LALT" $R0

SectionEnd

Section "TSF뷨" SecTSF

SetOutPath $INSTDIR\tsf

File tsf\yong.dll
File tsf\yong64.dll
File tsf\tsf-reg.exe
File tsf\tsf-reg64.exe

ExecWait '"$INSTDIR\tsf\tsf-reg.exe" -i'
ExecWait '"$INSTDIR\tsf\tsf-reg64.exe" -i'

${ConfigWrite} "$INSTDIR\yong.ini" "switch=" "NONE" $R0
${ConfigWrite} "$INSTDIR\yong.ini" "trigger=" "CTRL_LALT" $R0

SectionEnd

Section /o "metro" SecMetro

SetOutPath $INSTDIR
File "libyong.so"

SetOutPath $INSTDIR\w64
File "w64\libl.dll"
File "w64\libyong.so"
File "w64\libmb.so"
File "w64\libgbk.so"
File "w64\libcloud.so"

SectionEnd

Section /o "޸" SecFIX
WriteRegStr HKCU "Control Panel\Desktop" "LowLevelHooksTimeout" 0x000003E8
SectionEnd

;Desc
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SecMain} "Ƥļ"
!insertmacro MUI_DESCRIPTION_TEXT ${SecIME} "IMEģ飬иõļ"
!insertmacro MUI_DESCRIPTION_TEXT ${SecTSF} "TSFģ飬иõļ"
!insertmacro MUI_DESCRIPTION_TEXT ${SecMenu} "ڿʼ˵ṩ˵"
!insertmacro MUI_DESCRIPTION_TEXT ${SecMetro} "metro"
!insertmacro MUI_DESCRIPTION_TEXT ${SecFix} "޸ڷæϵͳżĸ"
!insertmacro MUI_FUNCTION_DESCRIPTION_END

Section "Uninstall"

loop:
FindWindow $R0 "yong_main"
IntCmp $R0 0 done
SendMessage $R0 2 0 0
Sleep 444
Goto loop
done:

RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}"
Delete "$SMSTARTUP\${PRODUCT_NAME}.lnk"

IfFileExists "$INSTDIR\imm\yong.dll" 0 +2
ExecWait '"rundll32.exe" "$INSTDIR\imm\yong.dll" Unreg'

IfFileExists "$INSTDIR\imm\yong64.dll" 0 +2
ExecWait '"rundll32.exe" "$INSTDIR\imm\yong64.dll" Unreg'

IfFileExists "$INSTDIR\tsf\tsf-reg.exe" 0 +2
ExecWait '"$INSTDIR\tsf\tsf-reg.exe" -u -d'

IfFileExists "$INSTDIR\tsf\tsf-reg64.exe" 0 +2
ExecWait '"$INSTDIR\tsf\tsf-reg64.exe" -u -d'

RMDir /r "$INSTDIR\mb"
RMDir /r "$INSTDIR\imm"
RmDir /r "$INSTDIR\tsf"
RMDir /r "$INSTDIR\skin"
RMDir /r "$INSTDIR\w64"

Delete "$INSTDIR\yong.exe"
Delete "$INSTDIR\yong-config.exe"
Delete "$INSTDIR\libyong.so"
Delete "$INSTDIR\libmb.so"
Delete "$INSTDIR\libgbk.so"
Delete "$INSTDIR\libcloud.so"
Delete "$INSTDIR\libl.dll"
Delete "$INSTDIR\README.txt"
Delete "$INSTDIR\yong.ini"
Delete "$INSTDIR\class.txt"
Delete "$INSTDIR\bihua.bin"
Delete "$INSTDIR\keyboard.ini"
Delete "$INSTDIR\normal.txt"
Delete "$INSTDIR\learn.dat"
Delete "$INSTDIR\yong.chm"

Delete "$INSTDIR\uninstall.exe"

MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Ƿûļ" IDYES +3
RMDir /r "$INSTDIR\.yong"
RMDir /r "$APPDATA\yong"
RMDir "$INSTDIR"

DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"

SectionEnd
